--
function processEconomy(day)
	--log(log_id, "T2:", LAST_BALANCE_DAY)
	local log_id = "economy_system"
	--
	log(log_id, "day > last_day")

	getIncome()
	processOutcome()
	
	LAST_BALANCE_DAY = tonumber(day)
end
--
function getIncome()
	
	local getFromSectors = function(sector, data)
		if ( (sector ~= nil) and (data ~= nil) ) then
			if ( Forces[data.owner][PLAYER] == ALLY ) then
				if ( data.income > 0 ) then
					addMoney(data.income)
				end
			end
		end
	end
	
	table.foreach(Sectors, getFromSectors)
	
	local getFromUpgrades = function(upgrade, data)
		if ( (upgrade ~= nil) and (data ~= nil) ) then
			if ( data.bought == true ) then
				if ( (data.sector ~= nil) ) then
					if ( Forces[Sectors[data.sector].owner][PLAYER] == ALLY ) then
						if ( data.bonus > 0 ) then
							addMoney(data.bonus)
						end
					end
				end
			end
		end
	end
	
	table.foreach(Upgrades, getFromUpgrades)
end
--
function processOutcome()

	local u = Upgrades
	local m = Mercs
	local s = Sectors
	
	local processMercs = function(merc, data)
		if ( (merc ~= nil) and (data ~= nil) ) then
			if ( (data.hired == true) and (data.alive == true) ) then
				local salary = getPersonParameter(merc, "SALARY")
				local money = getMoney()
				
				if ( (money - salary) >= 0 ) then
					deductMoney(salary)
				else
					stopTime()
					setMoney(0)
					dismissMerc(merc, "_hire_refuse_lazy")
				end
			end
		end
	end
	
	table.foreach(m, processMercs)
	
	local processSectors = function(sector, data)
		if ( (sector ~= nil) and (data ~= nil) ) then
			if ( Forces[data.owner][PLAYER] == ALLY ) then
				local money = getMoney()
				if ( (data.income < 0) and (money > 0) ) then
					if ( (money + data.income) >= 0 ) then
						deductMoney(data.income)
					else
						setMoney(0)
					end
				end
			end
		end
	end
	
	table.foreach(s, processSectors)
	
	local processUpgrades = function(upgrade, data)
		if ( (upgrade ~= nil) and (data ~= nil) ) then
			if ( data.bought == true ) then
				if ( (data.sector ~= nil) ) then
					if ( Forces[Sectors[data.sector].owner][PLAYER] == ALLY ) then
						if ( data.bonus < 0 ) then
							local money = getMoney()
							
							if ( (money + data.bonus) >= 0) then
								deductMoney(data.bonus)
							else
								setMoney(0)
								CampaignScript.onUpgradeSell(data.sector, upgrade)
							end
						end
					end
				end
			end
		end
	end
	
	table.foreach(u, processUpgrades)
end
--
function calcTooltip()
	local log_id = "_finance_tooltip_"
	local ft_sectors_plus = 0
	local ft_upgrades_plus = 0
	local ft_mercs_minus = 0
	local ft_additional_minus = 0
	local hmercs = getHiredMercs(true)
	
	local calcSalaries = function(index, name)
		log(log_id, "Getting salary for", name)
		ft_mercs_minus = ft_mercs_minus + getPersonParameter(name, "SALARY")
	end
	
	if ( hmercs ~= nil ) then
		table.foreach(hmercs, calcSalaries)
	end
	
	log(log_id, "Mercs expensies:", ft_mercs_minus)
	
	local calcUpgradesIncome = function(upgrade, data)
		if ( upgrade ~= nil ) then
			if ( data ~= nil ) then
				if ( data.bought == true ) then
					if ( data.sector ~= nil ) then
						if ( Forces[Sectors[data.sector].owner][PLAYER] == ALLY ) then
							if (data.bonus > 0) then
								log(log_id, "Getting bonus for", upgrade, "at", data.sector)
								ft_upgrades_plus = ft_upgrades_plus + data.bonus
							elseif ( data.bonus < 0 ) then
								log(log_id, "Getting expense for", upgrade, "at", data.sector)
								ft_additional_minus = ft_additional_minus - data.bonus
							end
						end
					end
				end
			end
		end
	end
	
	table.foreach(Upgrades, calcUpgradesIncome)
	
	log(log_id, "Upgrades income:", ft_upgrades_plus)
	
	local calcSectorsIncome = function(sector, data)
		if ( sector ~= nil ) then
			if ( data ~= nil ) then
				if ( Forces[data.owner][PLAYER] == ALLY ) then
					if ( data.income > 0 ) then
						log(log_id, "Getting income for", sector)
						ft_sectors_plus = ft_sectors_plus + data.income
					elseif ( data.income < 0 ) then
						log(log_id, "Getting expense for", sector)
						ft_additional_minus = ft_additional_minus - data.income
					end
				end
			end
		end
	end
	
	table.foreach(Sectors, calcSectorsIncome)
	
	log(log_id, "Sectors income:", ft_sectors_plus)
	log(log_id, "Additional expensies:", ft_additional_minus)
	
	setGVAR("ft_sectors_plus", ft_sectors_plus)
	setGVAR("ft_upgrades_plus", ft_upgrades_plus)
	setGVAR("ft_mercs_minus", ft_mercs_minus)
	setGVAR("ft_additional_minus",ft_additional_minus)
	
	return
end
--